/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/


#ifndef B_HIF_H
#define B_HIF_H

#include <typedefs.h>
#include "b_io.h"

/* SCRobinson, 10/97
 * This file contains function declarations for accessing 
 * the Fast-Host-Interface card (Win95 or WinNT PCI-drivers ONLY) from the
 * CAPI.
 *
 * These functions are contained in fhif32.c and called by wrapper functions 
 * in session.c or iocommon.c which switch between the different ports.
 *
 * *** IMPORTANT ***
 * Although the FastHIF has its own PCI driver which we use for reads/writes
 * we also use the gen. purpose Best PCI driver to get slotdata and 
 * device id's for different FastHIF cards.
 *
 * Therefore b_ntpcix.sys MUST BE ACTIVE ON THE HOST SYSTEM !!!
 */

/* these functions are in fhif32.c */

/* --------------------------------------------------------------------------
 * Standard I/O functions (see iocommon.c)
 * -------------------------------------------------------------------------- */

b_errtype BestHIFDeviceConnect(b_portnumtype OsHandle);
b_errtype BestHIFCheckConnection(b_portnumtype OsHandle);
b_errtype BestHIFIsDisconnected(b_portnumtype OsHandle);
void BestHIFReleaseConnection(b_portnumtype OsHandle);
b_errtype BestHifPortTimeoutSet(b_portnumtype OsHandle, 
                                BESTTIMEOUTS * pCallersTimeouts);

/* Default timeouts are defined in b_io.h */


/* --------------------------------------------------------------------------
 * Other exposed functions
 * -------------------------------------------------------------------------- */

b_errtype BestOpenHIF(b_int32 dwCardId, 
                      b_int32 * pHPSlotId, 
                      b_portnumtype * pOsHandle );

b_errtype BestCloseHIF(b_portnumtype OsHandle);

/* --------------------------------------------------------------------------
 * **TODO** Remove when ReadFile() and WriteFile() work.
 * -------------------------------------------------------------------------- */
b_errtype BestHIFIoCtlRead(b_handletype handle, 
                           b_int8 * pData,
                           b_int32 NumBytes,
                           b_int32 * pNumBytesRead,
                           b_int32 IoCtlCode);

b_errtype BestHIFIoCtlWrite( b_handletype handle, 
                             b_int8 * pData,
                             b_int32 NumBytes,
                             b_int32 * pNumBytesWritten,
                             b_int32 IoCtlCode);


#endif /* _B_HIF_H */
